[ env.ini ]
set var=CONF_REGION value="tr(1,World)"
set var=CONF_PROVIDER value="tr(2,Expert)"
set var=CONF_DESCRIPTION value="tr(3,Routed IPoA Packet Service configuration using always-on session connectivity.)"
set var=CONF_SERVICE value="tr(4,Routed IPoA - DHCP - no NAPT)"
set var=CONF_DATE value=""
set var=CONF_TPVERSION value=1.2.0
set var=HOST_SETUP value=auto
set var=UPGRADE_URL value=http://www.speedtouch.com/upgrade500.htm
set var=ATM_addr value="8.35"

[ wizard.ini ]
' ATM=PVC Settings
'----------------------------
def var=ATM type=grp desc="tr(5,Specify the details of the Routed IPoA Packet Service. All information should be provided by your ISP.)" alias="tr(6,Routed IPoA Packet Service)"
def var=ATM_addr type=combo grp=ATM alias="VPI/VCI" data="0.32,0.33,0.35,0.36,0.37,0.38,0.100,1.32,1.33,1.100,8.35,8.36,8.37,8.48,8.81" req=yes desc="tr(7,Choose a VPI/VCI from the list)" default="8.35"
'IP Settings
'-----------
def var=IP type=grp desc="tr(8,Specify the IP configuration for the Routed IPoA Packet Service. All information should be provided by your ISP.)" alias="tr(9,Routed IPoA IP Configuration)"
def var=IP_LOCAL type=ipaddr grp=IP alias="tr(10,Local IP address)" req desc="tr(11,Enter the local IP address.)"
def var=IP_REMOTE type=ipaddr grp=IP alias="tr(12,Remote IP address)" req desc="tr(13,Enter the remote IP address.)"
def var=IP_DEST type=ipaddr grp=IP alias="tr(14,Destination network)" default="0.0.0.0" desc="tr(15,By default any (0.0.0.0/0) destination network is accessible. If required, enter an IP address referring to a more specific destination network.)"
def var=IP_DESTMASK type=ipmask grp=IP alias="tr(16,Destination netmask.)" default="0.0.0.0" desc="tr(17,If applicable, enter a netmask appropriate for the specific destination network.)"
'ST Security
'-----------
def var=ST type=grp desc="tr(18,Specify user name and password to protect SpeedTouch administrative access.)" alias="tr(19,SpeedTouch Security)"
def var=%ST_SYS_USERNAME type=string grp=ST alias="tr(20,User Name)" desc="tr(21,Enter user name.)"
def var=%ST_SYS_PASSWORD type=passw grp=ST alias="tr(22,Password)" desc="tr(23,Enter your password.)" max=32
def var=dummy type=passwcheck grp=ST alias="tr(24,Confirm Password)" desc="tr(25,Re-enter your password)" linkvar=%ST_SYS_PASSWORD max=32

[ hostwizard.ini ]

[ phone.ini ]
add name=PVC_1 addr=$ATM_addr type=any
add name=USB addr=usb.0.35 type=any logging=off

[ bridge.ini ]
ifadd intf=USB dest=USB logging=off
ifattach intf=USB logging=off
config age=300 filter=no_WAN_broadcast

[ pptp.ini ]

[ dhcp.ini ]
config autodhcp=on scantime=10 state=enabled trace=off
policy verifyfirst=on trustclient=on
pool add name=LAN_private
pool config name=LAN_private poolstart=10.0.0.1 poolend=10.0.0.254 netmask=255.255.255.0 gateway=10.0.0.138 leasetime=7200

[ ethoa.ini ]

[ ipoa.ini ]
ifadd intf=IPoA_1 dest=PVC_1
ifattach intf=IPoA_1

[ pppoa.ini ]

[ pppoe.ini ]

[ pppoerelay.ini ]

[ cip.ini ]

[ ip.ini ]
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=10.0.0.138/24 intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=10.0.0.138
rtadd dst=224.0.0.0/4 intf=eth0
apadd addr=$IP_LOCAL intf=IPoA_1 pointopoint=$IP_REMOTE addroute=yes
rtadd dst=$IP_DEST dstmsk=$IP_DESTMASK gateway=$IP_LOCAL

[ dhcr.ini ]
ifconfig intf=eth0 relay=on
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138

[ autopvc.ini ]
config mode=passive type=bridge

[ system.ini ]
config upnp=enabled mdap=enabled dcache=enabled drst=enabled
#if $%ST_SYS_PASSWORD=""
setpassword password="" userid=$%ST_SYS_USERNAME
#else
setpassword password=$%ST_SYS_PASSWORD userid=$%ST_SYS_USERNAME
#endif

[ upnp.ini ]
config defcservice=IPoA_1

[ language.ini ]
langdef lang=nl charset=ISO-8859-1
t r="1, Wereld"
t r="2, Expert"
t r="3, Configuratie met routed-IPoA Packet-service en permanente verbinding."
t r="4, Routed IPoA - DHCP - geen NAPT"
t r="5, Geef de details van de routed-IPoA Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="6, Routed-IPoA Packet-service"
t r="7, Selecteer een VPI/VCI uit de lijst"
t r="8, Geef de IP-configuratie van de routed-IPoA Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="9, IP-configuratie routed IPoA"
t r="10, Lokaal IP-adres"
t r="11, Geef het lokale IP-adres in."
t r="12, Extern IP-adres"
t r="13, Geef het externe IP-adres in."
t r="14, Doelnetwerk"
t r="15, Standaard zijn alle doelnetwerken (0.0.0.0/0) bereikbaar. Indien nodig geef het IP-adres en netmasker in van een specifiek doelnetwerk."
t r="16, Netmasker van doelnetwerk."
t r="17, Indien van toepassing geef het netmasker van het doelnetwerk in."
t r="18, Geef de gebruikersnaam en het wachtwoord op waarmee u het beheer van de SpeedTouch wilt beveiligen."
t r="19, SpeedTouch-beveiliging"
t r="20, Gebruikersnaam"
t r="21, Geef uw gebruikersnaam in."
t r="22, Wachtwoord"
t r="23, Geef uw wachtwoord in."
t r="24, Wachtwoord bevestigen"
t r="25, Geef uw wachtwoord nogmaals in"
langdef lang=fr charset=ISO-8859-1
t r="1, Monde"
t r="2, Expert"
t r="3, Configuration du service de transmission par paquets IPoA rout  l'aide d'une connexion de session permanente."
t r="4, IPoA rout, DHCP, sans NAPT"
t r="5, Spcifiez les dtails relatifs au service de transmission par paquets IPoA rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="6, Service de transmission par paquets IPoA rout"
t r="7, Slectionnez un VPI/VCI dans la liste"
t r="8, Spcifiez la configuration IP du service de transmission par paquets IPoA rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="9, Configuration IP de la connexion IPoA route"
t r="10, Adresse IP locale"
t r="11, Entrez l'adresse IP locale."
t r="12, Adresse IP distante"
t r="13, Entrez l'adresse IP distante."
t r="14, Rseau de destination"
t r="15, Par dfaut, tout rseau de destination (0.0.0.0/0) est accessible. Le cas chant, entrez une adresse IP faisant rfrence  un rseau de destination plus spcifique."
t r="16, Masque de rseau de destination"
t r="17, Le cas chant, entrez un masque de rseau appropri pour le rseau de destination spcifique."
t r="18, Indiquez un nom d'utilisateur et un mot de passe pour protger l'accs administratif de SpeedTouch."
t r="19, Scurit SpeedTouch"
t r="20, Nom d'utilisateur"
t r="21, Entrez un nom d'utilisateur."
t r="22, Mot de passe"
t r="23, Entrez votre mot de passe."
t r="24, Confirmer le mot de passe"
t r="25, Entrez  nouveau le mot de passe"
langdef lang=de charset=ISO-8859-1
t r="1, Welt"
t r="2, Expert"
t r="3, Konfiguration des Routed IPoA-Paketdienstes bei stndiger Sitzungsverbindung."
t r="4, Routed IPoA - DHCP - kein NAPT"
t r="5, Geben Sie die Einzelheiten zum Routed IPoA-Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="6, Routed IPoA-Paketdienst"
t r="7, Whlen Sie einen VPI/VCI-Eintrag aus der Liste aus"
t r="8, Geben Sie die IP-Konfiguration fr den Routed IPoA-Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="9, IP-Konfiguration fr Routed IPoA"
t r="10, Lokale IP-Adresse"
t r="11, Geben Sie die lokale IP-Adresse ein."
t r="12, Remote-IP-Adresse"
t r="13, Geben Sie die Remote-IP-Adresse ein."
t r="14, Zielnetzwerk"
t r="15, Standardmig ist der Zugriff auf jedes (0.0.0.0/0) Zielnetzwerk mglich. Geben Sie gegebenenfalls eine IP-Adresse ein, die auf ein spezifischeres Zielnetzwerk verweist."
t r="16, Zielnetzmaske."
t r="17, Geben Sie gegebenenfalls eine fr das spezifische Zielnetzwerk entsprechende Netzmaske ein."
t r="18, Geben Sie den Benutzernamen und das Kennwort an, um den Administratorzugriff auf das SpeedTouch zu schtzen."
t r="19, SpeedTouch Sicherheit"
t r="20, Benutzername"
t r="21, Geben Sie den Benutzernamen ein."
t r="22, Kennwort"
t r="23, Geben Sie das Kennwort ein."
t r="24, Kennwort besttigen"
t r="25, Geben Sie das Kennwort erneut ein."
langdef lang=it charset=ISO-8859-1
t r="1, Mondo"
t r="2, Esperta"
t r="3, Configurazione per la trasmissione di pacchetti in modalit routed IPoA con connettivit di sessione sempre attiva."
t r="4, Routed IPoA - DHCP - no NAPT"
t r="5, Specificare i dettagli per la trasmissione di pacchetti in modalit routed IPoA. Tutte le informazioni devono essere fornite dall'ISP."
t r="6, Trasmissione di pacchetti in modalit routed IPoA"
t r="7, Scegliere un VPI/VCI dall'elenco"
t r="8, Specificare la configurazione IP per la trasmissione di pacchetti in modalit routed IPoA. Tutte le informazioni devono essere fornite dall'ISP."
t r="9, Configurazione IP per modalit routed IPoA"
t r="10, Indirizzo IP locale"
t r="11, Immettere l'indirizzo IP locale."
t r="12, Indirizzo IP remoto"
t r="13, Immettere l'indirizzo IP remoto."
t r="14, Rete di destinazione"
t r="15, Per impostazione predefinita,  accessibile qualunque rete di destinazione (0.0.0.0/0). Se necessario, immettere un indirizzo IP relativo a una rete di destinazione pi specifica."
t r="16, Subnet mask di destinazione"
t r="17, Se opportuno, immettere una subnet mask appropriata per la rete di destinazione specifica."
t r="18, Specificare un nome utente e una password per proteggere l'accesso amministrativo dello SpeedTouch."
t r="19, Sicurezza SpeedTouch"
t r="20, Nome utente"
t r="21, Immettere il nome utente."
t r="22, Password"
t r="23, Immettere la password."
t r="24, Conferma password"
t r="25, Immettere nuovamente la password."
langdef lang=pt charset=ISO-8859-1
t r="1, Mundo"
t r="2, Avanado"
t r="3, Configurao do Servio de Pacote do IPoA Roteado usando a conectividade da sesso sempre ativa."
t r="4, IPoA roteado - DHCP - nenhum NAPT"
t r="5, Especifique os detalhes do Servio de Pacote do IPoA Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="6, Servio de Pacote do IPoA Roteado"
t r="7, Escolha um VPI/VCI na lista"
t r="8, Especifique a configurao IP do Servio de Pacote IPoA Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="9, Configurao IP do IPoA roteado"
t r="10, Endereo IP local"
t r="11, Insira o endereo IP local."
t r="12, Endereo IP remoto"
t r="13, Insira o endereo IP remoto."
t r="14, Rede de destino"
t r="15, Por padro, qualquer rede de destino (0.0.0.0/0)  acessvel. Se necessrio, insira um endereo IP que refere-se a uma rede de destino mais especfica."
t r="16, Mscara de rede de destino."
t r="17, Se aplicvel, insira uma mscara de rede apropriada para a rede de destino especfica."
t r="18, Especifique o nome do usurio e a senha para proteger o acesso administrativo do SpeedTouch."
t r="19, Segurana do SpeedTouch"
t r="20, Nome do usurio"
t r="21, Digite o nome do usurio."
t r="22, Senha"
t r="23, Digite sua senha."
t r="24, Confirme a senha"
t r="25, Digite novamente sua senha"
langdef lang=es charset=ISO-8859-1
t r="1, Mundial"
t r="2, Experto"
t r="3, Configuracin de servicios de paquetes IPoA enrutados mediante conectividad de sesin siempre activada."
t r="4, IPoA enrutados; DHCP; no NAPT"
t r="5, Indique los detalles del servicio de paquetes IPoA enrutados. Toda la informacin debe proporcionarla el ISP."
t r="6, Servicio de paquetes IPoA enrutados"
t r="7, Elija un identificador VPI/VCI de la lista"
t r="8, Indique la configuracin de IP para el servicio de paquetes IPoA enrutados. Toda la informacin debe proporcionarla el ISP."
t r="9, Configuracin IP de IPoA enrutada"
t r="10, Direccin IP local"
t r="11, Escriba la direccin IP local."
t r="12, Direccin IP remota"
t r="13, Escriba la direccin IP remota."
t r="14, Red de destino"
t r="15, De manera predeterminada se puede acceder a cualquier red de destino (0.0.0.0/0). Si se requiere, escriba una direccin IP que haga referencia a una red de destino ms especfica."
t r="16, Mscara de red de destino."
t r="17, Si es aplicable, escriba una mscara de red apropiada para la red de destino especfica."
t r="18, Indique el nombre de usuario y la contrasea para proteger el acceso administrativo a SpeedTouch."
t r="19, Seguridad de SpeedTouch"
t r="20, Nombre de usuario"
t r="21, Escriba el nombre de usuario."
t r="22, Contrasea"
t r="23, Escriba la contrasea."
t r="24, Confirme la contrasea"
t r="25, Vuelva a escribir la contrasea"
langdef lang=sv charset=ISO-8859-1
t r="1, Vrld"
t r="2, Expert"
t r="3, Konfiguration fr Routed IPoA Packet Service som anvnder permanent sessionsanslutning."
t r="4, Routed IPoA - DHCP - ingen NAPT"
t r="5, Ange information om Routed IPoA Packet Service. Din ISP ska kunna ge all information."
t r="6, Routed IPoA Packet Service"
t r="7, Vlj VPI/VCI frn listan"
t r="8, Ange IP-konfiguration fr Routed IPoA Packet Service. Din ISP ska kunna ge all information."
t r="9, IP-konfiguration fr Routed IPoA"
t r="10, Lokal IP-adress"
t r="11, Ange lokal IP-adress."
t r="12, Fjrr-IP-address"
t r="13, Ange fjrr-IP-adress."
t r="14, Destinationsntverk"
t r="15, Som standard r varje (0.0.0.0/0) destinationsntverk tkomligt. Ange om s behvs en IP-adress som hnvisar till ett mer specifikt destinationsntverk."
t r="16, Destinationsntmask."
t r="17, Ange om s behvs en lmplig ntmask fr det specifika destinationsntverket."
t r="18, Ange anvndarnamn och lsenord fr att skydda administrativ tkomst till SpeedTouch."
t r="19, SpeedTouch-skerhet"
t r="20, Anvndarnamn"
t r="21, Ange anvndarnamn."
t r="22, Lsenord"
t r="23, Ange lsenord."
t r="24, Bekrfta lsenord"
t r="25, Ange ditt lsenord igen"

[ endofarch ]
